DROP PROCEDURE [hips].[EpisodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 30 March 2012
-- Description:   Gets a specific record/records from the Episode Table
-- Modified:    22/11/2012 sbiber added Ward,Room,Bed
-- Modified:    18/12/2012 sbiber changed UploadConsent to ConsentWithdrawn
-- Modified:    15/09/2013 pstalley-gordon  Added BlockCancelledEpisodeLifeCycles to remove cancelled episodes
-- =============================================
CREATE PROCEDURE [hips].[EpisodeGet] 
(
	@EpisodeId INT = NULL,
	@PatientId INT = NULL,
	@DateLastUpdated DATETIME = NULL,
	@BlockCancelledEpisodeLifeCycles BIT = 0
)
AS
BEGIN
SELECT e.EpisodeId
	, e.PatientId
	, e.SourceSystemEpisodeId
	, e.AdmissionDate
	, e.AdmissionReason
	, e.DischargeDate
	, e.ResponsibleProviderId
	, e.EpisodeTypeId
	, et.Description AS EpisodeType
	, e.EpisodeLifecycleId
	, ec.Description AS EpisodeLifecycle
	, e.ConsentWithdrawn
	, e.Ward
	, e.Room
	, e.Bed
	, e.DateCreated
	, e.UserCreated
	, e.DateModified
	, e.UserModified
FROM hips.Episode e
LEFT JOIN [hips].[EpisodeType] AS et on et.EpisodeTypeId = e.EpisodeTypeId
LEFT JOIN [hips].[EpisodeLifecycle] AS ec on ec.EpisodeLifecycleId = e.EpisodeLifecycleId
WHERE (@EpisodeId IS NULL OR e.EpisodeId = @EpisodeId)
AND   (@PatientId IS NULL OR e.PatientId = @PatientId)
AND   (@BlockCancelledEpisodeLifeCycles=0 OR (e.EpisodeLifecycleId NOT IN (4,5,6,10,12))) 	 
AND   (@DateLastUpdated IS NULL OR e.DateModified > @DateLastUpdated)
ORDER BY e.AdmissionDate DESC

END
GO

